/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1997 - 1999 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIUReferenceUtils.cpp
//
//
//	Description:
//		This library contains the source and
//		routines to simplify the use of suites and also some
//		helpful common plug-in functions. 
//
//	Use:
//		PIUReferenceUtils is intended to group common functions
//		into higher-level macros and routines to simplify
//		plug-in programming.
//
//	Version history:
//		Version 1.0.0	4/22/1998	Created for Photoshop 5.0
//			Written by Andrew Coven.
//
//-------------------------------------------------------------------------------

//namespace std {
//	using ::size_t;
//};
#include "PIUReferenceUtils.h"
#include "PIUSuites.h" // Include here to prevent circular errors.
	
//-------------------------------------------------------------------------------
//
//	Make/Free
//
//	This provides simpler Make and Free methods for references.
//
//-------------------------------------------------------------------------------
PIActionReference PIUReferenceUtils_t::Make(void)
	{
	PIActionReference reference = 0;
	
	if (sPSActionReference.IsValid())
		{
		SPErr error = sPSActionReference->Make(&reference);
		}
		
	return reference;
	}
	
void PIUReferenceUtils_t::Free(PIActionReference* reference)
	{
	if (sPSActionReference.IsValid() && reference != NULL && *reference != NULL)
		{
		SPErr error = sPSActionReference->Free(*reference);
		*reference = 0;
		}
	}

//-------------------------------------------------------------------------------
// end PIUReferenceUtils.cpp
